/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.design.base.component;

import java.util.ArrayList;
import java.util.List;
import net.sf.dynamicreports.design.base.component.DRDesignComponent;
import net.sf.dynamicreports.design.base.component.DRDesignListCell;
import net.sf.dynamicreports.design.constant.ComponentGroupType;
import net.sf.dynamicreports.design.definition.component.DRIDesignList;
import net.sf.dynamicreports.report.constant.HorizontalCellComponentAlignment;
import net.sf.dynamicreports.report.constant.ListType;
import net.sf.dynamicreports.report.constant.VerticalCellComponentAlignment;

public class DRDesignList
extends DRDesignComponent
implements DRIDesignList {
    private static final long serialVersionUID = 10000L;
    private List<DRDesignListCell> listCells;
    private List<DRDesignComponent> components;
    private ListType type;
    private ComponentGroupType componentGroupType;
    private int gap;
    private boolean calculateComponents;
    private Boolean removable;
    private DRDesignComponent backgroundComponent;

    public DRDesignList() {
        this(ListType.HORIZONTAL);
    }

    public DRDesignList(ListType type) {
        super("list");
        this.type = type;
        this.calculateComponents = true;
    }

    @Override
    protected void init() {
        super.init();
        this.listCells = new ArrayList<DRDesignListCell>();
        this.components = new ArrayList<DRDesignComponent>();
    }

    public List<DRDesignComponent> getComponents() {
        return this.components;
    }

    public void addComponent(DRDesignComponent component) {
        this.components.add(component);
        this.listCells.add(new DRDesignListCell(component));
    }

    public void addComponent(int index, DRDesignComponent component) {
        this.components.add(index, component);
        this.listCells.add(index, new DRDesignListCell(component));
    }

    public void addComponent(int index, HorizontalCellComponentAlignment horizontalAlignment, VerticalCellComponentAlignment verticalAlignment, DRDesignComponent component) {
        this.components.add(index, component);
        this.listCells.add(index, new DRDesignListCell(horizontalAlignment, verticalAlignment, component));
    }

    public void addComponent(HorizontalCellComponentAlignment horizontalAlignment, VerticalCellComponentAlignment verticalAlignment, DRDesignComponent component) {
        this.components.add(component);
        this.listCells.add(new DRDesignListCell(horizontalAlignment, verticalAlignment, component));
    }

    public List<DRDesignListCell> getListCells() {
        return this.listCells;
    }

    public boolean isEmpty() {
        return this.components.isEmpty();
    }

    @Override
    public ListType getType() {
        return this.type;
    }

    public void setType(ListType type) {
        this.type = type;
    }

    @Override
    public ComponentGroupType getComponentGroupType() {
        return this.componentGroupType;
    }

    public void setComponentGroupType(ComponentGroupType componentGroupType) {
        this.componentGroupType = componentGroupType;
    }

    public int getGap() {
        return this.gap;
    }

    public void setGap(int gap) {
        this.gap = gap;
    }

    public boolean isCalculateComponents() {
        return this.calculateComponents;
    }

    public void setCalculateComponents(boolean calculateComponents) {
        this.calculateComponents = calculateComponents;
    }

    public boolean isRemovable() {
        if (this.removable != null) {
            return this.removable;
        }
        return ListType.VERTICAL.equals((Object)this.type);
    }

    public void setRemovable(Boolean removable) {
        this.removable = removable;
    }

    @Override
    public DRDesignComponent getBackgroundComponent() {
        return this.backgroundComponent;
    }

    public void setBackgroundComponent(DRDesignComponent backgroundComponent) {
        this.backgroundComponent = backgroundComponent;
    }
}

