/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.search;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRStyledTextAttributeSelector;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.PrintElementId;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextUtil;
import net.sf.jasperreports.search.HitSpanInfo;
import net.sf.jasperreports.search.HitTermInfo;
import net.sf.jasperreports.search.LuceneSimpleAnalyzer;
import net.sf.jasperreports.search.LuceneSpansInfo;
import net.sf.jasperreports.search.SpansInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.search.spans.SpanMultiTermQueryWrapper;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanOrQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.BytesRef;

public class LuceneUtil {
    private static final Log log = LogFactory.getLog(LuceneUtil.class);
    private static final String CONTENT_FIELD = "content";
    private JRStyledTextAttributeSelector noneSelector;
    private JRStyledTextUtil styledTextUtil;
    private Analyzer analyzer;
    private IndexWriter writer;
    private FieldType fieldType;
    private boolean isCaseSensitive;
    private boolean isWholeWordsOnly;
    private boolean removeAccents;

    public LuceneUtil(JasperReportsContext jasperReportsContext, boolean isCaseSensitive, boolean isWholeWordsOnly, boolean removeAccents) {
        this.isCaseSensitive = isCaseSensitive;
        this.isWholeWordsOnly = isWholeWordsOnly;
        this.removeAccents = removeAccents;
        this.noneSelector = JRStyledTextAttributeSelector.getNoneSelector(jasperReportsContext);
        this.styledTextUtil = JRStyledTextUtil.getInstance(jasperReportsContext);
        this.fieldType = new FieldType();
        this.fieldType.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
        this.fieldType.setTokenized(true);
        this.fieldType.setStored(true);
        this.fieldType.setStoreTermVectors(true);
        this.fieldType.setStoreTermVectorPositions(true);
        this.fieldType.setStoreTermVectorOffsets(true);
        this.fieldType.freeze();
    }

    public SpansInfo getSpansInfo(JasperPrint jasperPrint, String queryString) throws IOException, JRException {
        Long start = System.currentTimeMillis();
        Directory dir = this.createLuceneDirectory(jasperPrint);
        if (log.isDebugEnabled()) {
            log.debug((Object)("original query: [" + queryString + "]"));
        }
        DirectoryReader reader = DirectoryReader.open((Directory)dir);
        IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
        List<String> queryTerms = this.getQueryTerms(queryString);
        int queryTermsSize = queryTerms.size();
        SpanQuery query = this.buildQuery(queryTerms);
        if (log.isDebugEnabled()) {
            log.debug((Object)("lucene query: [" + query.toString() + "]"));
        }
        TopDocs results = searcher.search((Query)query, Integer.MAX_VALUE);
        ScoreDoc[] hits = results.scoreDocs;
        if (log.isDebugEnabled()) {
            log.debug((Object)"The query produced hits in two documents");
        }
        LinkedHashMap<Integer, TreeSet<Term>> hitTermsMap = new LinkedHashMap<Integer, TreeSet<Term>>();
        for (ScoreDoc hit : hits) {
            TreeSet<Term> hitTerms = new TreeSet<Term>();
            this.getHitTerms((Query)query, searcher, hit.doc, hitTerms);
            hitTermsMap.put(hit.doc, hitTerms);
        }
        LuceneSpansInfo spansInfo = new LuceneSpansInfo(queryTerms.size(), queryTerms);
        for (Map.Entry entry : hitTermsMap.entrySet()) {
            int docId = (Integer)entry.getKey();
            Terms termVector = reader.getTermVector(docId, CONTENT_FIELD);
            Document doc = searcher.doc(docId);
            String uid = doc.get("uid");
            String pageNo = doc.get("pageNo");
            ArrayList<HitTermInfo> hitTermInfoList = new ArrayList<HitTermInfo>();
            Set terms = (Set)entry.getValue();
            for (Term term : terms) {
                BytesRef termBytesRef;
                TermsEnum iterator = termVector.iterator();
                if (!iterator.seekExact(termBytesRef = new BytesRef((CharSequence)term.text()))) continue;
                PostingsEnum docsAndPositions = iterator.postings(null, 120);
                docsAndPositions.nextDoc();
                int freq = docsAndPositions.freq();
                for (int i = 0; i < freq; ++i) {
                    HitTermInfo termInfo = new HitTermInfo(docsAndPositions.nextPosition(), docsAndPositions.startOffset(), docsAndPositions.endOffset(), term.text());
                    hitTermInfoList.add(termInfo);
                    if (queryTermsSize != 1) continue;
                    HitSpanInfo tsi = new HitSpanInfo(termInfo);
                    tsi.setPageNo(pageNo);
                    spansInfo.addSpanInfo(uid, tsi);
                }
            }
            if (queryTermsSize <= 1) continue;
            this.validateHitTerms(hitTermInfoList, queryTerms, uid, pageNo, spansInfo);
        }
        reader.close();
        if (log.isDebugEnabled()) {
            log.debug((Object)("search took: " + (System.currentTimeMillis() - start) + " ms"));
        }
        return spansInfo;
    }

    protected void validateHitTerms(List<HitTermInfo> hitTermInfoList, List<String> queryTerms, String uid, String pageNo, SpansInfo spansInfo) {
        Collections.sort(hitTermInfoList);
        int queryTermsSize = queryTerms.size();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Validating hitTermInfoList: " + hitTermInfoList + " against: " + queryTerms));
        }
        int sz = hitTermInfoList.size();
        for (int i = 0; i < sz - queryTermsSize + 1; ++i) {
            boolean isValidSpan = true;
            ArrayList<HitTermInfo> validSpan = new ArrayList<HitTermInfo>();
            for (int j = 0; j < queryTermsSize; ++j) {
                HitTermInfo htiIJ = hitTermInfoList.get(i + j);
                String queryTermJ = queryTerms.get(j);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Comparing: " + htiIJ + " with " + queryTermJ));
                }
                if (j == 0) {
                    if (!htiIJ.getValue().endsWith(queryTermJ)) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)(htiIJ + " does not end with " + queryTermJ));
                        }
                        isValidSpan = false;
                        break;
                    }
                } else if (j < queryTermsSize - 1) {
                    if (!htiIJ.getValue().equals(queryTermJ)) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)(htiIJ + " does not equal " + queryTermJ));
                        }
                        isValidSpan = false;
                        break;
                    }
                } else if (!htiIJ.getValue().startsWith(queryTermJ)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(htiIJ + " does not start with " + queryTermJ));
                    }
                    isValidSpan = false;
                    break;
                }
                validSpan.add(htiIJ);
            }
            if (!isValidSpan) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found valid span: " + validSpan));
            }
            HitSpanInfo tsi = new HitSpanInfo(validSpan);
            tsi.setPageNo(pageNo);
            spansInfo.addSpanInfo(uid, tsi);
        }
    }

    protected Directory createLuceneDirectory(JasperPrint jasperPrint) throws IOException, JRException {
        Long start = System.currentTimeMillis();
        RAMDirectory dir = new RAMDirectory();
        Analyzer analyzer = this.getConfiguredAnalyzer();
        IndexWriterConfig iwc = new IndexWriterConfig(analyzer);
        iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
        this.writer = new IndexWriter((Directory)dir, iwc);
        List<JRPrintPage> pages = jasperPrint.getPages();
        if (pages != null && pages.size() > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("there are " + pages.size() + " pages to be indexed"));
            }
            int ps = pages.size();
            for (int i = 0; i < ps; ++i) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("indexing page: " + i));
                }
                this.indexPage(pages.get(i), i);
            }
        }
        this.writer.close();
        if (log.isDebugEnabled()) {
            log.debug((Object)("index creation took: " + (System.currentTimeMillis() - start) + " ms"));
        }
        return dir;
    }

    protected void indexPage(JRPrintPage page, int pageNo) throws IOException {
        List<JRPrintElement> elements = page.getElements();
        if (page.getElements().size() > 0) {
            this.indexElements(pageNo, elements);
        }
    }

    protected void indexElements(int pageNo, List<JRPrintElement> elements) throws IOException {
        for (int i = 0; i < elements.size(); ++i) {
            JRPrintElement element = elements.get(i);
            if (element instanceof JRPrintText) {
                this.addContentField(pageNo, (JRPrintText)element);
                continue;
            }
            if (!(element instanceof JRPrintFrame)) continue;
            JRPrintFrame frame = (JRPrintFrame)element;
            this.indexElements(pageNo, frame.getElements());
        }
    }

    protected void addContentField(int pageNo, JRPrintText element) throws IOException {
        JRStyledText styledText = this.getStyledText(element);
        String allText = styledText == null ? "" : styledText.getText();
        if (allText != null && allText.length() > 0) {
            Field tf = new Field(CONTENT_FIELD, (CharSequence)allText, (IndexableFieldType)this.fieldType);
            Document doc = new Document();
            doc.add((IndexableField)new StoredField("pageNo", pageNo));
            PrintElementId peid = PrintElementId.forElement(element);
            doc.add((IndexableField)new StringField("uid", peid.toString(), Field.Store.YES));
            if (log.isDebugEnabled()) {
                log.debug((Object)this.displayTokens(allText, peid.toString()));
            }
            doc.add((IndexableField)tf);
            this.writer.addDocument((Iterable)doc);
        }
    }

    protected Analyzer getConfiguredAnalyzer() {
        if (this.analyzer == null) {
            this.analyzer = new LuceneSimpleAnalyzer(this.isCaseSensitive, this.removeAccents);
        }
        return this.analyzer;
    }

    protected JRStyledText getStyledText(JRPrintText textElement) {
        return this.styledTextUtil.getStyledText(textElement, this.noneSelector);
    }

    protected SpanQuery buildQuery(List<String> queryTerms) {
        ArrayList<Object> clauses = new ArrayList<Object>();
        int ln = queryTerms.size();
        for (int i = 0; i < ln; ++i) {
            String term = queryTerms.get(i);
            if (this.isWholeWordsOnly) {
                clauses.add(new SpanTermQuery(new Term(CONTENT_FIELD, term)));
                continue;
            }
            if (i == 0) {
                term = "*" + term;
            }
            if (i == ln - 1) {
                term = term + "*";
            }
            clauses.add(new SpanMultiTermQueryWrapper((MultiTermQuery)new WildcardQuery(new Term(CONTENT_FIELD, term))));
        }
        if (clauses.size() > 1) {
            return new SpanNearQuery(clauses.toArray(new SpanQuery[0]), 0, true);
        }
        if (clauses.size() == 1) {
            return (SpanQuery)clauses.get(0);
        }
        return null;
    }

    protected List<String> getQueryTerms(String queryString) throws IOException {
        ArrayList<String> queryTerms = new ArrayList<String>();
        Analyzer analyzer = this.getConfiguredAnalyzer();
        TokenStream tokenStream = analyzer.tokenStream(null, queryString);
        CharTermAttribute charTermAttribute = (CharTermAttribute)tokenStream.addAttribute(CharTermAttribute.class);
        tokenStream.reset();
        while (tokenStream.incrementToken()) {
            queryTerms.add(charTermAttribute.toString());
        }
        return queryTerms;
    }

    protected String displayTokens(String text, String elementId) throws IOException {
        LuceneSimpleAnalyzer analyzer = new LuceneSimpleAnalyzer(this.isCaseSensitive, this.removeAccents);
        StringBuilder sb = new StringBuilder();
        sb.append(elementId).append(": ").append(text).append(": ");
        TokenStream tokenStream = analyzer.tokenStream(null, new StringReader(text));
        CharTermAttribute charTermAttribute = (CharTermAttribute)tokenStream.addAttribute(CharTermAttribute.class);
        OffsetAttribute offsetAttribute = (OffsetAttribute)tokenStream.addAttribute(OffsetAttribute.class);
        tokenStream.reset();
        while (tokenStream.incrementToken()) {
            int startOffset = offsetAttribute.startOffset();
            int endOffset = offsetAttribute.endOffset();
            String term = charTermAttribute.toString();
            sb.append("[" + term + "](" + startOffset + "," + endOffset + ") ");
        }
        return sb.toString();
    }

    protected void getHitTerms(Query query, IndexSearcher searcher, int docId, Set<Term> hitTerms) throws IOException {
        if (query instanceof SpanTermQuery) {
            if (searcher.explain(query, docId).isMatch()) {
                hitTerms.add(((SpanTermQuery)query).getTerm());
            }
            return;
        }
        if (query instanceof MultiTermQuery) {
            if (!(query instanceof FuzzyQuery)) {
                ((MultiTermQuery)query).setRewriteMethod(MultiTermQuery.SCORING_BOOLEAN_REWRITE);
            }
            this.getHitTerms(query.rewrite(searcher.getIndexReader()), searcher, docId, hitTerms);
            return;
        }
        if (query instanceof SpanNearQuery) {
            for (SpanQuery bc : ((SpanNearQuery)query).getClauses()) {
                this.getHitTerms((Query)bc, searcher, docId, hitTerms);
            }
            return;
        }
        if (query instanceof SpanOrQuery) {
            for (SpanQuery bc : ((SpanOrQuery)query).getClauses()) {
                this.getHitTerms((Query)bc, searcher, docId, hitTerms);
            }
            return;
        }
        if (query instanceof SpanMultiTermQueryWrapper) {
            ((SpanMultiTermQueryWrapper)query).setRewriteMethod(SpanMultiTermQueryWrapper.SCORING_SPAN_QUERY_REWRITE);
            this.getHitTerms(query.rewrite(searcher.getIndexReader()), searcher, docId, hitTerms);
        }
    }
}

