/*
 * Decompiled with CFR 0.152.
 */
package com.zenofx.classguard.bootstrap;

import com.zenofx.classguard.bootstrap.ClassGuard;
import com.zenofx.classguard.bootstrap.FileSelectPanel;
import com.zenofx.classguard.bootstrap.GUIHelper;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public class LicenseDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 829811648964660739L;
    private JButton okButton;
    private JButton cancelButton;
    private FileSelectPanel filePanel;
    private ClassGuard classGuard;
    private String license;
    private String productName;
    private LookAndFeel oldLnF;

    public LicenseDialog(ClassGuard classGuard, String string) {
        super((Frame)null, "ClassGuard License Manager");
        if (System.getProperty("os.name").startsWith("Windows")) {
            this.setLocationByPlatform(true);
            try {
                this.oldLnF = UIManager.getLookAndFeel();
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.classGuard = classGuard;
        this.productName = string;
        this.setModal(true);
        this.createContents();
    }

    private void createContents() {
        String string;
        Container container = this.getContentPane();
        container.setFocusCycleRoot(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = GUIHelper.INSETS;
        container.setLayout(new GridBagLayout());
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        String string2 = "No valid license found for " + this.productName + ". Please contact your vendor.";
        container.add((Component)new JLabel(string2), gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        container.add((Component)new JLabel("System-ID"), gridBagConstraints);
        try {
            string = this.classGuard.getSystemId();
        }
        catch (IOException iOException) {
            string = "unknown";
        }
        JTextField jTextField = new JTextField(string, 40);
        jTextField.setEditable(false);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 1;
        container.add((Component)jTextField, gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        container.add((Component)new JLabel("License file"), gridBagConstraints);
        this.filePanel = new FileSelectPanel();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 1;
        container.add((Component)this.filePanel, gridBagConstraints);
        this.okButton = GUIHelper.createButton("OK");
        this.okButton.addActionListener(this);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 0;
        container.add((Component)this.okButton, gridBagConstraints);
        this.cancelButton = GUIHelper.createButton("Cancel");
        this.cancelButton.addActionListener(this);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 1;
        container.add((Component)this.cancelButton, gridBagConstraints);
        this.pack();
        this.setResizable(false);
    }

    public String getLicense() {
        return this.license;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            File file = this.filePanel.getSelectedFile();
            if (file == null) {
                this.error("Please select a license file");
                return;
            }
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                byte[] byArray = new byte[fileInputStream.available()];
                fileInputStream.read(byArray);
                this.license = new String(byArray, "UTF-8");
                fileInputStream.close();
            }
            catch (Exception exception) {
                this.error("Could not read license file.");
                return;
            }
            try {
                this.classGuard.initLicense(this.license);
            }
            catch (Exception exception) {
                this.error("License file not valid.");
                this.license = null;
                return;
            }
            if (this.oldLnF != null) {
                try {
                    UIManager.setLookAndFeel(this.oldLnF);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.dispose();
        } else if (actionEvent.getSource() == this.cancelButton) {
            this.license = null;
            this.dispose();
        }
    }

    private void error(String string) {
        JOptionPane.showMessageDialog(this, string, "Error", 0);
    }
}

