/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.jhardware.info.bios.unix;

import java.util.HashMap;
import java.util.Map;
import org.jutils.jhardware.info.bios.AbstractBiosInfo;
import org.jutils.jhardware.util.HardwareInfoUtils;

public final class UnixBiosInfo
extends AbstractBiosInfo {
    private static final String DMIPATH = "/sys/devices/virtual/dmi/id/";

    private static String getBiosData() {
        String fullData = "";
        if (HardwareInfoUtils.isSudo()) {
            fullData = String.valueOf(fullData) + HardwareInfoUtils.executeCommand("sudo", "dmidecode", "--type", "0");
        } else {
            fullData = String.valueOf(fullData) + "\tRelease Date: " + HardwareInfoUtils.executeCommand("cat", "/sys/devices/virtual/dmi/id/bios_date");
            fullData = String.valueOf(fullData) + "\tVendor: " + HardwareInfoUtils.executeCommand("cat", "/sys/devices/virtual/dmi/id/bios_vendor");
            fullData = String.valueOf(fullData) + "\tVersion: " + HardwareInfoUtils.executeCommand("cat", "/sys/devices/virtual/dmi/id/bios_version");
        }
        return fullData;
    }

    @Override
    protected Map<String, String> parseInfo() {
        String[] dataStringLines;
        HashMap<String, String> biosDataMap = new HashMap<String, String>();
        String[] stringArray = dataStringLines = UnixBiosInfo.getBiosData().split("\\r?\\n");
        int n = dataStringLines.length;
        int n2 = 0;
        while (n2 < n) {
            String dataLine = stringArray[n2];
            if (dataLine.startsWith("\t")) {
                String[] dataStringInfo = dataLine.split(":");
                if (dataStringInfo.length == 2) {
                    biosDataMap.put(dataStringInfo[0].trim(), dataStringInfo[1].trim());
                } else if (dataStringInfo.length == 1 && "\tCharacteristics".equals(dataStringInfo[0])) {
                    biosDataMap.put(dataStringInfo[0].trim(), UnixBiosInfo.getCharacteristics(dataStringLines));
                }
            }
            ++n2;
        }
        return biosDataMap;
    }

    private static String getCharacteristics(String[] dataStringLines) {
        StringBuilder characteristics = new StringBuilder();
        String[] stringArray = dataStringLines;
        int n = dataStringLines.length;
        int n2 = 0;
        while (n2 < n) {
            String characteristicsLine = stringArray[n2];
            if (characteristicsLine.trim().length() > 0 && characteristicsLine.startsWith("\t\t")) {
                characteristics.append(characteristicsLine.trim()).append("\n");
            }
            ++n2;
        }
        return characteristics.toString();
    }
}

