/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.jhardware.util;

import com.profesorfalken.jsensors.JSensors;
import com.profesorfalken.jsensors.model.components.Cpu;
import com.profesorfalken.jsensors.model.sensors.Temperature;
import com.profesorfalken.wmi4java.WMI4Java;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.jutils.jhardware.util.HardwareInfoUtils;

public class TemperatureUtils {
    private static final String NOT_DETECTED = "NOT DETECTED";
    private static final String CPUTEMP_THERMAL_ROOT = "/sys/class/thermal/thermal_zone";
    private static final String CPUTEMP_THERMAL_FILE = "temp";

    private static String getCpuTemperatureByjSensors() {
        List cpus = JSensors.get.components().cpus;
        if (cpus.size() > 0) {
            Cpu cpu = (Cpu)cpus.get(0);
            if (cpu.sensors.temperatures != null && cpu.sensors.temperatures.size() > 0) {
                for (Temperature temp : cpu.sensors.temperatures) {
                    if (temp.value == null) continue;
                    return String.valueOf(temp.value.intValue());
                }
            }
        }
        return NOT_DETECTED;
    }

    public static String getCpuTemperatureForWindows() {
        String temperature = TemperatureUtils.getCpuTemperatureByjSensors();
        if (NOT_DETECTED.equals(temperature)) {
            Map temperatureDataMap = WMI4Java.get().VBSEngine().namespace("root/wmi").getWMIObject("MSAcpi_ThermalZoneTemperature");
            temperature = temperatureDataMap.containsKey("CurrentTemperature") ? String.valueOf(Integer.valueOf((String)temperatureDataMap.get("CurrentTemperature")) / 10 - 273) : NOT_DETECTED;
        }
        return temperature;
    }

    public static String getCpuTemperatureForLinux() {
        String temperature;
        block2: {
            temperature = TemperatureUtils.getCpuTemperatureByjSensors();
            if (NOT_DETECTED.equals(temperature)) {
                int sensorIndex = 0;
                while (new File(CPUTEMP_THERMAL_ROOT + sensorIndex).exists()) {
                    String tempFile;
                    String value;
                    if ((value = HardwareInfoUtils.getSingleValueFromFile(tempFile = CPUTEMP_THERMAL_ROOT + sensorIndex++ + "/" + CPUTEMP_THERMAL_FILE)) == null || value.isEmpty()) continue;
                    temperature = String.valueOf(Integer.valueOf(value.trim()) / 1000);
                    break block2;
                }
                temperature = NOT_DETECTED;
            }
        }
        return temperature;
    }
}

