/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder.component;

import net.sf.dynamicreports.report.base.DRTableOfContentsHeading;
import net.sf.dynamicreports.report.base.component.DRComponent;
import net.sf.dynamicreports.report.builder.AbstractBuilder;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.expression.Expressions;
import net.sf.dynamicreports.report.builder.style.ReportStyleBuilder;
import net.sf.dynamicreports.report.builder.tableofcontents.TableOfContentsHeadingBuilder;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.definition.expression.DRIPropertyExpression;
import org.apache.commons.lang3.Validate;

public abstract class ComponentBuilder<T extends ComponentBuilder<T, U>, U extends DRComponent>
extends AbstractBuilder<T, U> {
    private static final long serialVersionUID = 10000L;

    protected ComponentBuilder(U object) {
        super(object);
    }

    public T setStyle(ReportStyleBuilder style) {
        if (style != null) {
            ((DRComponent)this.getObject()).setStyle(style.getStyle());
        } else {
            ((DRComponent)this.getObject()).setStyle(null);
        }
        return (T)this;
    }

    public T setPrintWhenExpression(DRIExpression<Boolean> printWhenExpression) {
        ((DRComponent)this.getObject()).setPrintWhenExpression(printWhenExpression);
        return (T)this;
    }

    public T removeLineWhenBlank() {
        return this.setRemoveLineWhenBlank(true);
    }

    public T setRemoveLineWhenBlank(Boolean removeLineWhenBlank) {
        ((DRComponent)this.getObject()).setRemoveLineWhenBlank(removeLineWhenBlank);
        return (T)this;
    }

    public T addProperty(DRIPropertyExpression propertyExpression) {
        ((DRComponent)this.getComponent()).addPropertyExpression(propertyExpression);
        return (T)this;
    }

    public T addProperty(String name, DRIExpression<String> valueExpression) {
        ((DRComponent)this.getComponent()).addPropertyExpression(Expressions.property(name, valueExpression));
        return (T)this;
    }

    public T addProperty(String name, String value) {
        ((DRComponent)this.getComponent()).addPropertyExpression(Expressions.property(name, value));
        return (T)this;
    }

    public T setTableOfContentsHeading(String label) {
        TableOfContentsHeadingBuilder tocHeading = DynamicReports.tableOfContentsHeading(label);
        return this.setTableOfContentsHeading(tocHeading);
    }

    public T setTableOfContentsHeading(TableOfContentsHeadingBuilder tocHeading) {
        Validate.notNull((Object)tocHeading, (String)"tocHeading must not be null", (Object[])new Object[0]);
        ((DRComponent)this.getComponent()).setTableOfContentsHeading((DRTableOfContentsHeading)tocHeading.build());
        return (T)this;
    }

    public U getComponent() {
        return (U)((DRComponent)this.build());
    }
}

