/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder.component;

import net.sf.dynamicreports.report.base.component.DRComponent;
import net.sf.dynamicreports.report.base.component.DRList;
import net.sf.dynamicreports.report.base.component.DRListCell;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.component.Components;
import net.sf.dynamicreports.report.builder.component.DimensionComponentBuilder;
import net.sf.dynamicreports.report.builder.component.VerticalListCellBuilder;
import net.sf.dynamicreports.report.constant.ListType;
import org.apache.commons.lang3.Validate;

public class VerticalListBuilder
extends DimensionComponentBuilder<VerticalListBuilder, DRList> {
    private static final long serialVersionUID = 10000L;

    protected VerticalListBuilder() {
        super(new DRList(ListType.VERTICAL));
    }

    public VerticalListBuilder add(ComponentBuilder<?, ?> ... components) {
        Validate.notNull(components, (String)"components must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])components, (String)"components must not contains null component", (Object[])new Object[0]);
        for (ComponentBuilder<?, ?> component : components) {
            ((DRList)this.getObject()).addComponent((DRComponent)component.getComponent());
        }
        return this;
    }

    public VerticalListBuilder add(Integer gap, ComponentBuilder<?, ?> ... components) {
        Validate.notNull(components, (String)"components must not be null", (Object[])new Object[0]);
        for (ComponentBuilder<?, ?> component : components) {
            this.add(Components.vListCell(Components.filler().setHeight(gap)).heightFixed());
            this.add(component);
        }
        return this;
    }

    public VerticalListBuilder add(VerticalListCellBuilder ... cells) {
        Validate.notNull((Object)cells, (String)"cells must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])cells, (String)"cells must not contains null cell", (Object[])new Object[0]);
        for (VerticalListCellBuilder cell : cells) {
            ((DRList)this.getObject()).addCell((DRListCell)cell.build());
        }
        return this;
    }

    public VerticalListBuilder add(Integer gap, VerticalListCellBuilder ... cells) {
        Validate.notNull((Object)cells, (String)"cells must not be null", (Object[])new Object[0]);
        for (VerticalListCellBuilder cell : cells) {
            this.add(Components.vListCell(Components.filler().setHeight(gap)).heightFixed(), cell);
        }
        return this;
    }

    public VerticalListBuilder setGap(Integer gap) {
        ((DRList)this.getObject()).setGap(gap);
        return this;
    }

    public VerticalListBuilder setBackgroundComponent(ComponentBuilder<?, ?> backgroundComponent) {
        Validate.notNull(backgroundComponent, (String)"backgroundComponent must not be null", (Object[])new Object[0]);
        ((DRList)this.getObject()).setBackgroundComponent((DRComponent)backgroundComponent.build());
        return this;
    }

    public DRList getList() {
        return (DRList)this.build();
    }
}

