/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.io.inputstream;

import java.io.EOFException;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import net.lingala.zip4j.io.inputstream.CipherInputStream;
import net.lingala.zip4j.io.inputstream.DecompressedInputStream;

public class InflaterInputStream
extends DecompressedInputStream {
    private Inflater inflater;
    private byte[] buff;
    private byte[] singleByteBuffer = new byte[1];
    private int len;

    public InflaterInputStream(CipherInputStream cipherInputStream) {
        super(cipherInputStream);
        this.inflater = new Inflater(true);
        this.buff = new byte[512];
    }

    @Override
    public int read() throws IOException {
        int readLen = this.read(this.singleByteBuffer);
        if (readLen == -1) {
            return -1;
        }
        return this.singleByteBuffer[0];
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            int n;
            while ((n = this.inflater.inflate(b, off, len)) == 0) {
                if (this.inflater.finished() || this.inflater.needsDictionary()) {
                    return -1;
                }
                if (!this.inflater.needsInput()) continue;
                this.fill();
            }
            return n;
        }
        catch (DataFormatException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void pushBackInputStreamIfNecessary(PushbackInputStream pushbackInputStream) throws IOException {
        int n = this.inflater.getRemaining();
        if (n > 0) {
            byte[] rawDataCache = this.getLastReadRawDataCache();
            pushbackInputStream.unread(rawDataCache, this.len - n, n);
        }
    }

    private void fill() throws IOException {
        this.len = super.read(this.buff, 0, this.buff.length);
        if (this.len == -1) {
            throw new EOFException("Unexpected end of ZLIB input stream");
        }
        this.inflater.setInput(this.buff, 0, this.len);
    }
}

