/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.tasks;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Random;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.headers.HeaderUtil;
import net.lingala.zip4j.headers.HeaderWriter;
import net.lingala.zip4j.io.outputstream.SplitOutputStream;
import net.lingala.zip4j.model.EndOfCentralDirectoryRecord;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.model.enums.RandomAccessFileMode;
import net.lingala.zip4j.progress.ProgressMonitor;
import net.lingala.zip4j.tasks.AbstractZipTaskParameters;
import net.lingala.zip4j.tasks.AsyncZipTask;
import net.lingala.zip4j.util.FileUtils;

public class RemoveEntryFromZipFileTask
extends AsyncZipTask<RemoveEntryFromZipFileTaskParameters> {
    private ZipModel zipModel;

    public RemoveEntryFromZipFileTask(ProgressMonitor progressMonitor, boolean runInThread, ZipModel zipModel) {
        super(progressMonitor, runInThread);
        this.zipModel = zipModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeTask(RemoveEntryFromZipFileTaskParameters taskParameters, ProgressMonitor progressMonitor) throws IOException {
        if (this.zipModel.isSplitArchive()) {
            throw new ZipException("This is a split archive. Zip file format does not allow updating split/spanned files");
        }
        File temporaryZipFile = this.getTemporaryFile(this.zipModel.getZipFile().getPath());
        boolean successFlag = false;
        try (SplitOutputStream outputStream = new SplitOutputStream(temporaryZipFile);
             RandomAccessFile inputStream = new RandomAccessFile(this.zipModel.getZipFile(), RandomAccessFileMode.READ.getValue());){
            int indexOfFileHeader = HeaderUtil.getIndexOfFileHeader(this.zipModel, taskParameters.fileHeader);
            long offsetLocalFileHeader = this.getOffsetLocalFileHeader(taskParameters.fileHeader);
            long offsetStartOfCentralDirectory = this.getOffsetOfStartOfCentralDirectory(this.zipModel);
            List<FileHeader> fileHeaders = this.zipModel.getCentralDirectory().getFileHeaders();
            long offsetEndOfCompressedData = this.getOffsetEndOfCompressedData(indexOfFileHeader, offsetStartOfCentralDirectory, fileHeaders);
            if (indexOfFileHeader == 0) {
                if (this.zipModel.getCentralDirectory().getFileHeaders().size() > 1) {
                    FileUtils.copyFile(inputStream, outputStream, offsetEndOfCompressedData + 1L, offsetStartOfCentralDirectory, progressMonitor);
                }
            } else if (indexOfFileHeader == fileHeaders.size() - 1) {
                FileUtils.copyFile(inputStream, outputStream, 0L, offsetLocalFileHeader, progressMonitor);
            } else {
                FileUtils.copyFile(inputStream, outputStream, 0L, offsetLocalFileHeader, progressMonitor);
                FileUtils.copyFile(inputStream, outputStream, offsetEndOfCompressedData + 1L, offsetStartOfCentralDirectory, progressMonitor);
            }
            this.verifyIfTaskIsCancelled();
            this.updateHeaders(this.zipModel, outputStream, indexOfFileHeader, offsetEndOfCompressedData, offsetLocalFileHeader, taskParameters.charset);
            successFlag = true;
        }
        finally {
            this.cleanupFile(successFlag, this.zipModel.getZipFile(), temporaryZipFile);
        }
    }

    private long getOffsetOfStartOfCentralDirectory(ZipModel zipModel) {
        long offsetStartCentralDir = zipModel.getEndOfCentralDirectoryRecord().getOffsetOfStartOfCentralDirectory();
        if (zipModel.isZip64Format() && zipModel.getZip64EndOfCentralDirectoryRecord() != null) {
            offsetStartCentralDir = zipModel.getZip64EndOfCentralDirectoryRecord().getOffsetStartCentralDirectoryWRTStartDiskNumber();
        }
        return offsetStartCentralDir;
    }

    private long getOffsetEndOfCompressedData(int indexOfFileHeader, long offsetStartOfCentralDirectory, List<FileHeader> fileHeaders) {
        if (indexOfFileHeader == fileHeaders.size() - 1) {
            return offsetStartOfCentralDirectory - 1L;
        }
        FileHeader nextFileHeader = fileHeaders.get(indexOfFileHeader + 1);
        long offsetEndOfCompressedFile = nextFileHeader.getOffsetLocalHeader() - 1L;
        if (nextFileHeader.getZip64ExtendedInfo() != null && nextFileHeader.getZip64ExtendedInfo().getOffsetLocalHeader() != -1L) {
            offsetEndOfCompressedFile = nextFileHeader.getZip64ExtendedInfo().getOffsetLocalHeader() - 1L;
        }
        return offsetEndOfCompressedFile;
    }

    private File getTemporaryFile(String zipPathWithName) {
        Random random = new Random();
        File tmpFile = new File(zipPathWithName + random.nextInt(10000));
        while (tmpFile.exists()) {
            tmpFile = new File(zipPathWithName + random.nextInt(10000));
        }
        return tmpFile;
    }

    private long getOffsetLocalFileHeader(FileHeader fileHeader) {
        long offsetLocalFileHeader = fileHeader.getOffsetLocalHeader();
        if (fileHeader.getZip64ExtendedInfo() != null && fileHeader.getZip64ExtendedInfo().getOffsetLocalHeader() != -1L) {
            offsetLocalFileHeader = fileHeader.getZip64ExtendedInfo().getOffsetLocalHeader();
        }
        return offsetLocalFileHeader;
    }

    private void updateHeaders(ZipModel zipModel, SplitOutputStream splitOutputStream, int indexOfFileHeader, long offsetEndOfCompressedFile, long offsetLocalFileHeader, Charset charset) throws IOException {
        this.updateEndOfCentralDirectoryRecord(zipModel, splitOutputStream);
        zipModel.getCentralDirectory().getFileHeaders().remove(indexOfFileHeader);
        this.updateFileHeadersWithLocalHeaderOffsets(zipModel.getCentralDirectory().getFileHeaders(), offsetEndOfCompressedFile, offsetLocalFileHeader, indexOfFileHeader);
        HeaderWriter headerWriter = new HeaderWriter();
        headerWriter.finalizeZipFile(zipModel, splitOutputStream, charset);
    }

    private void updateEndOfCentralDirectoryRecord(ZipModel zipModel, SplitOutputStream splitOutputStream) throws IOException {
        EndOfCentralDirectoryRecord endOfCentralDirectoryRecord = zipModel.getEndOfCentralDirectoryRecord();
        endOfCentralDirectoryRecord.setOffsetOfStartOfCentralDirectory(splitOutputStream.getFilePointer());
        endOfCentralDirectoryRecord.setTotalNumberOfEntriesInCentralDirectory(endOfCentralDirectoryRecord.getTotalNumberOfEntriesInCentralDirectory() - 1);
        endOfCentralDirectoryRecord.setTotalNumberOfEntriesInCentralDirectoryOnThisDisk(endOfCentralDirectoryRecord.getTotalNumberOfEntriesInCentralDirectoryOnThisDisk() - 1);
        zipModel.setEndOfCentralDirectoryRecord(endOfCentralDirectoryRecord);
    }

    private void updateFileHeadersWithLocalHeaderOffsets(List<FileHeader> fileHeaders, long offsetEndOfCompressedFile, long offsetLocalFileHeader, int indexOfFileHeader) {
        for (int i = indexOfFileHeader; i < fileHeaders.size(); ++i) {
            FileHeader fileHeader = fileHeaders.get(i);
            long offsetLocalHdr = fileHeader.getOffsetLocalHeader();
            if (fileHeader.getZip64ExtendedInfo() != null && fileHeader.getZip64ExtendedInfo().getOffsetLocalHeader() != -1L) {
                offsetLocalHdr = fileHeader.getZip64ExtendedInfo().getOffsetLocalHeader();
            }
            fileHeader.setOffsetLocalHeader(offsetLocalHdr - (offsetEndOfCompressedFile - offsetLocalFileHeader) - 1L);
        }
    }

    private void cleanupFile(boolean successFlag, File zipFile, File temporaryZipFile) throws ZipException {
        if (successFlag) {
            this.restoreFileName(zipFile, temporaryZipFile);
        } else {
            temporaryZipFile.delete();
        }
    }

    private void restoreFileName(File zipFile, File temporaryZipFile) throws ZipException {
        if (zipFile.delete()) {
            if (!temporaryZipFile.renameTo(zipFile)) {
                throw new ZipException("cannot rename modified zip file");
            }
        } else {
            throw new ZipException("cannot delete old zip file");
        }
    }

    @Override
    protected long calculateTotalWork(RemoveEntryFromZipFileTaskParameters taskParameters) {
        return this.zipModel.getZipFile().length() - taskParameters.fileHeader.getCompressedSize();
    }

    @Override
    protected ProgressMonitor.Task getTask() {
        return ProgressMonitor.Task.REMOVE_ENTRY;
    }

    public static class RemoveEntryFromZipFileTaskParameters
    extends AbstractZipTaskParameters {
        private FileHeader fileHeader;

        public RemoveEntryFromZipFileTaskParameters(FileHeader fileHeader, Charset charset) {
            super(charset);
            this.fileHeader = fileHeader;
        }
    }
}

