/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.util;

import java.io.File;
import java.util.Calendar;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.LocalFileHeader;
import net.lingala.zip4j.model.enums.CompressionMethod;

public class Zip4jUtil {
    public static boolean isStringNotNullAndNotEmpty(String str) {
        return str != null && str.trim().length() > 0;
    }

    public static boolean createDirectoryIfNotExists(File file) throws ZipException {
        if (file == null) {
            throw new ZipException("output path is null");
        }
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw new ZipException("output directory is not valid");
            }
        } else if (!file.mkdirs()) {
            throw new ZipException("Cannot create output directories");
        }
        return true;
    }

    public static long javaToDosTime(long time) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(time);
        int year = cal.get(1);
        if (year < 1980) {
            return 0x210000L;
        }
        return year - 1980 << 25 | cal.get(2) + 1 << 21 | cal.get(5) << 16 | cal.get(11) << 11 | cal.get(12) << 5 | cal.get(13) >> 1;
    }

    public static long dosToJavaTme(long dosTime) {
        int sec = (int)(2L * (dosTime & 0x1FL));
        int min = (int)(dosTime >> 5 & 0x3FL);
        int hrs = (int)(dosTime >> 11 & 0x1FL);
        int day = (int)(dosTime >> 16 & 0x1FL);
        int mon = (int)((dosTime >> 21 & 0xFL) - 1L);
        int year = (int)((dosTime >> 25 & 0x7FL) + 1980L);
        Calendar cal = Calendar.getInstance();
        cal.set(year, mon, day, hrs, min, sec);
        cal.set(14, 0);
        return cal.getTime().getTime();
    }

    public static byte[] convertCharArrayToByteArray(char[] charArray) {
        byte[] bytes = new byte[charArray.length];
        for (int i = 0; i < charArray.length; ++i) {
            bytes[i] = (byte)charArray[i];
        }
        return bytes;
    }

    public static CompressionMethod getCompressionMethod(LocalFileHeader localFileHeader) {
        if (localFileHeader.getCompressionMethod() != CompressionMethod.AES_INTERNAL_ONLY) {
            return localFileHeader.getCompressionMethod();
        }
        if (localFileHeader.getAesExtraDataRecord() == null) {
            throw new RuntimeException("AesExtraDataRecord not present in local header for aes encrypted data");
        }
        return localFileHeader.getAesExtraDataRecord().getCompressionMethod();
    }
}

