/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.tasks;

import java.io.IOException;
import java.nio.charset.Charset;
import net.lingala.zip4j.io.inputstream.SplitInputStream;
import net.lingala.zip4j.io.inputstream.ZipInputStream;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.progress.ProgressMonitor;
import net.lingala.zip4j.tasks.AbstractExtractFileTask;
import net.lingala.zip4j.tasks.AbstractZipTaskParameters;

public class ExtractFileTask
extends AbstractExtractFileTask<ExtractFileTaskParameters> {
    private char[] password;
    private SplitInputStream splitInputStream;

    public ExtractFileTask(ProgressMonitor progressMonitor, boolean runInThread, ZipModel zipModel, char[] password) {
        super(progressMonitor, runInThread, zipModel);
        this.password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeTask(ExtractFileTaskParameters taskParameters, ProgressMonitor progressMonitor) throws IOException {
        try (ZipInputStream zipInputStream = this.createZipInputStream(taskParameters.fileHeader, taskParameters.charset);){
            this.extractFile(zipInputStream, taskParameters.fileHeader, taskParameters.outputPath, taskParameters.newFileName, progressMonitor);
        }
        finally {
            if (this.splitInputStream != null) {
                this.splitInputStream.close();
            }
        }
    }

    @Override
    protected long calculateTotalWork(ExtractFileTaskParameters taskParameters) {
        return taskParameters.fileHeader.getUncompressedSize();
    }

    protected ZipInputStream createZipInputStream(FileHeader fileHeader, Charset charset) throws IOException {
        this.splitInputStream = new SplitInputStream(this.getZipModel().getZipFile(), this.getZipModel().isSplitArchive(), this.getZipModel().getEndOfCentralDirectoryRecord().getNumberOfThisDisk());
        this.splitInputStream.prepareExtractionForFileHeader(fileHeader);
        return new ZipInputStream(this.splitInputStream, this.password, charset);
    }

    public static class ExtractFileTaskParameters
    extends AbstractZipTaskParameters {
        private String outputPath;
        private FileHeader fileHeader;
        private String newFileName;

        public ExtractFileTaskParameters(String outputPath, FileHeader fileHeader, String newFileName, Charset charset) {
            super(charset);
            this.outputPath = outputPath;
            this.fileHeader = fileHeader;
            this.newFileName = newFileName;
        }
    }
}

