/*
 * Decompiled with CFR 0.152.
 */
package com.zenofx.classguard.bootstrap;

import com.zenofx.classguard.bootstrap.ClassGuard;
import com.zenofx.classguard.bootstrap.LicenseDialog;
import com.zenofx.classguard.bootstrap.LicenseInterface;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;

public class LicenseAdapter
implements LicenseInterface {
    @Override
    public String loadLicense(String string) {
        if (string == null) {
            return null;
        }
        try {
            Preferences preferences = Preferences.userNodeForPackage(net.jsecurity.classguard.bootstrap.ClassGuard.class);
            return preferences.get(string, null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public String requestLicense(ClassGuard classGuard, String string) throws IOException {
        if (GraphicsEnvironment.isHeadless()) {
            System.err.println("License GUI not available");
            System.err.println("Your system id is " + classGuard.getSystemId());
            return null;
        }
        LicenseDialog licenseDialog = new LicenseDialog(classGuard, string);
        licenseDialog.setVisible(true);
        return licenseDialog.getLicense();
    }

    @Override
    public void storeLicense(String string, String string2) throws IOException {
        try {
            Preferences preferences = Preferences.userNodeForPackage(net.jsecurity.classguard.bootstrap.ClassGuard.class);
            preferences.put(string, string2);
            preferences.flush();
        }
        catch (Exception exception) {
            throw new IOException("Couldn't save license to registry");
        }
    }

    @Override
    public void error(String string) {
        if (GraphicsEnvironment.isHeadless()) {
            System.err.println("Error: " + string);
        } else {
            JOptionPane.showMessageDialog(null, string, "Error", 0);
        }
    }
}

