/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.lang.ref.WeakReference;
import java.util.Hashtable;
import java.util.Stack;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.ClientConnection;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.ClientResultSet;
import org.apache.derby.client.am.Section;
import org.apache.derby.client.am.SqlException;

public class SectionManager {
    private Agent agent_;
    private final Stack<Section> freeSectionsNonHold_;
    private final Stack<Section> freeSectionsHold_;
    private int nextAvailableSectionNumber_ = 1;
    byte[] holdPKGNAMCBytes = null;
    byte[] noHoldPKGNAMCBytes = null;
    private static final String packageNameWithHold__ = "SYSLH000";
    private static final String packageNameWithNoHold__ = "SYSLN000";
    private static final String cursorNamePrefixWithHold__ = "SQL_CURLH000C";
    private static final String cursorNamePrefixWithNoHold__ = "SQL_CURLN000C";
    private final Hashtable<String, Section> positionedUpdateCursorNameToQuerySection_ = new Hashtable();
    private final Hashtable<String, WeakReference<ClientResultSet>> positionedUpdateCursorNameToResultSet_ = new Hashtable();
    private final int maxNumSections_ = 32768;

    public SectionManager(Agent agent) {
        this.agent_ = agent;
        this.freeSectionsNonHold_ = new Stack();
        this.freeSectionsHold_ = new Stack();
    }

    void setPKGNAMCBytes(byte[] byArray, int n) {
        if (n == 1) {
            this.agent_.sectionManager_.holdPKGNAMCBytes = byArray;
        } else if (n == 2) {
            this.agent_.sectionManager_.noHoldPKGNAMCBytes = byArray;
        }
    }

    Section getDynamicSection(int n) throws SqlException {
        if (n == 1) {
            return this.getSection(this.freeSectionsHold_, packageNameWithHold__, cursorNamePrefixWithHold__, n);
        }
        if (n == 2) {
            return this.getSection(this.freeSectionsNonHold_, packageNameWithNoHold__, cursorNamePrefixWithNoHold__, n);
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.3"), n);
    }

    private Section getSection(Stack stack, String string, String string2, int n) throws SqlException {
        if (!stack.empty()) {
            return (Section)stack.pop();
        }
        if (this.nextAvailableSectionNumber_ < Short.MAX_VALUE) {
            String string3 = string2 + this.nextAvailableSectionNumber_;
            Section section = new Section(this.agent_, string, this.nextAvailableSectionNumber_, string3, n);
            ++this.nextAvailableSectionNumber_;
            return section;
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ200.S"), "32000");
    }

    void freeSection(Section section, int n) {
        if (n == 1) {
            this.freeSectionsHold_.push(section);
        } else if (n == 2) {
            this.freeSectionsNonHold_.push(section);
        }
    }

    Section getPositionedUpdateSection(Section section) throws SqlException {
        ClientConnection clientConnection = this.agent_.connection_;
        return this.getDynamicSection(clientConnection.holdability());
    }

    Section getPositionedUpdateSection(String string, boolean bl) throws SqlException {
        Section section = this.positionedUpdateCursorNameToQuerySection_.get(string);
        if (section != null) {
            Section section2 = this.getPositionedUpdateSection(section);
            section2.setClientCursorName(section.getClientCursorName());
            section2.serverCursorNameForPositionedUpdate_ = section.getServerCursorName();
            return section2;
        }
        return null;
    }

    void mapCursorNameToQuerySection(String string, Section section) {
        this.positionedUpdateCursorNameToQuerySection_.put(string, section);
    }

    void mapCursorNameToResultSet(String string, ClientResultSet clientResultSet) {
        this.positionedUpdateCursorNameToResultSet_.put(string, new WeakReference<ClientResultSet>(clientResultSet));
    }

    ClientResultSet getPositionedUpdateResultSet(String string) throws SqlException {
        ClientResultSet clientResultSet = (ClientResultSet)this.positionedUpdateCursorNameToResultSet_.get(string).get();
        if (clientResultSet == null) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL16.S"), "update");
        }
        return clientResultSet.resultSetType_ == 1003 ? null : clientResultSet;
    }

    void removeCursorNameToResultSetMapping(String string, String string2) {
        if (string != null) {
            this.positionedUpdateCursorNameToResultSet_.remove(string);
        }
        if (string2 != null) {
            this.positionedUpdateCursorNameToResultSet_.remove(string2);
        }
    }

    void removeCursorNameToQuerySectionMapping(String string, String string2) {
        if (string != null) {
            this.positionedUpdateCursorNameToQuerySection_.remove(string);
        }
        if (string2 != null) {
            this.positionedUpdateCursorNameToQuerySection_.remove(string2);
        }
    }
}

