/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.design.transformation;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.sf.dynamicreports.design.base.DRDesignDataset;
import net.sf.dynamicreports.design.definition.DRIDesignDataset;
import net.sf.dynamicreports.design.exception.DRDesignReportException;
import net.sf.dynamicreports.design.transformation.DatasetExpressionTransform;
import net.sf.dynamicreports.design.transformation.DesignTransformAccessor;
import net.sf.dynamicreports.report.definition.DRIDataset;
import net.sf.dynamicreports.report.exception.DRException;

public class DatasetTransform {
    private DesignTransformAccessor accessor;
    private Map<String, DRIDesignDataset> datasets;
    private Map<DRIDataset, DRDesignDataset> designDatasets;

    public DatasetTransform(DesignTransformAccessor accessor) {
        this.accessor = accessor;
        this.datasets = new HashMap<String, DRIDesignDataset>();
        this.designDatasets = new HashMap<DRIDataset, DRDesignDataset>();
    }

    public DRDesignDataset transform(DRIDataset dataset) throws DRException {
        if (dataset == null) {
            return null;
        }
        if (this.designDatasets.containsKey(dataset)) {
            return this.designDatasets.get(dataset);
        }
        DatasetExpressionTransform datasetExpressionTransform = new DatasetExpressionTransform(this.accessor, dataset);
        datasetExpressionTransform.transform();
        DRDesignDataset designDataset = new DRDesignDataset(datasetExpressionTransform);
        if (dataset.getQuery() != null) {
            designDataset.setQuery(this.accessor.getReportTransform().query(dataset.getQuery()));
        }
        designDataset.setConnectionExpression(this.accessor.getExpressionTransform().transformExpression(dataset.getConnectionExpression()));
        designDataset.setDataSourceExpression(this.accessor.getExpressionTransform().transformExpression(dataset.getDataSourceExpression()));
        designDataset.setFilterExpression(datasetExpressionTransform.transformExpression(dataset.getFilterExpression(), "DYNAMICREPORTS_SCRIPTLET"));
        this.addDataset(dataset, designDataset);
        return designDataset;
    }

    public DatasetExpressionTransform getDatasetExpressionTransform(DRIDataset dataset) {
        return this.designDatasets.get(dataset).getDatasetExpressionTransform();
    }

    protected DRDesignDataset getDesignDataset(DRIDataset dataset) {
        return this.designDatasets.get(dataset);
    }

    private void addDataset(DRIDataset dataset, DRDesignDataset designDataset) {
        if (this.datasets.containsKey(designDataset.getName())) {
            throw new DRDesignReportException("Duplicate declaration of dataset \"" + designDataset.getName() + "\"");
        }
        this.datasets.put(designDataset.getName(), designDataset);
        this.designDatasets.put(dataset, designDataset);
    }

    public Collection<DRIDesignDataset> getDatasets() {
        return this.datasets.values();
    }
}

