/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.design.transformation;

import net.sf.dynamicreports.design.base.DRDesignMargin;
import net.sf.dynamicreports.design.base.DRDesignPage;
import net.sf.dynamicreports.design.transformation.DesignTransformAccessor;
import net.sf.dynamicreports.design.transformation.TemplateTransform;
import net.sf.dynamicreports.report.definition.DRIMargin;
import net.sf.dynamicreports.report.exception.DRException;

public class PageTransform {
    private TemplateTransform templateTransform;
    private DRDesignPage page;
    private int maxBandWidth;

    public PageTransform(DesignTransformAccessor accessor) {
        this.templateTransform = accessor.getTemplateTransform();
        this.page = new DRDesignPage();
    }

    public void transform() throws DRException {
        this.page.setHeight(this.templateTransform.getPageHeight());
        this.page.setOrientation(this.templateTransform.getPageOrientation());
        this.page.setMargin(this.margin(this.templateTransform.getPageMargin()));
        this.page.setColumnsPerPage(this.templateTransform.getPageColumnsPerPage());
        this.page.setColumnSpace(this.templateTransform.getPageColumnSpace());
    }

    private DRDesignMargin margin(DRIMargin margin) {
        DRDesignMargin designMargin = new DRDesignMargin();
        designMargin.setTop(margin.getTop());
        designMargin.setLeft(margin.getLeft());
        designMargin.setBottom(margin.getBottom());
        designMargin.setRight(margin.getRight());
        return designMargin;
    }

    public DRDesignPage getPage() {
        return this.page;
    }

    public void transformPageWidth() throws DRException {
        int pageWidth = this.templateTransform.getPageWidth();
        this.maxBandWidth = pageWidth - this.getPage().getMargin().getLeft() - this.getPage().getMargin().getRight();
        this.page.setWidth(pageWidth);
        this.page.setColumnWidth(this.templateTransform.getPageColumnWidth(this.page));
    }

    public int getMaxBandWidth() {
        return this.maxBandWidth;
    }
}

