/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.design.transformation.expressions;

import java.util.List;
import net.sf.dynamicreports.report.builder.expression.AbstractComplexExpression;
import net.sf.dynamicreports.report.definition.DRICustomValues;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;

public class TocReferenceExpression
extends AbstractComplexExpression<String> {
    private static final long serialVersionUID = 10000L;
    private int level;
    private String expressionName;
    private boolean customId;
    private boolean isCustomValue;

    public TocReferenceExpression(int level, String expressionName, DRIExpression<?> labelExpression, DRIExpression<String> anchorNameExpression, DRIExpression<?> customValueExpression) {
        this.level = level;
        this.expressionName = expressionName;
        this.customId = anchorNameExpression != null;
        this.addExpression(labelExpression);
        if (anchorNameExpression != null) {
            this.addExpression(anchorNameExpression);
        }
        boolean bl = this.isCustomValue = customValueExpression != null;
        if (customValueExpression != null) {
            this.addExpression(customValueExpression);
        }
    }

    @Override
    public String evaluate(List<?> values, ReportParameters reportParameters) {
        String id;
        Object customValue = null;
        if (this.customId) {
            id = (String)values.get(1);
            if (this.isCustomValue) {
                customValue = values.get(2);
            }
        } else {
            id = this.expressionName + "_" + reportParameters.getReportRowNumber();
            if (this.isCustomValue) {
                customValue = values.get(1);
            }
        }
        DRICustomValues customValues = (DRICustomValues)reportParameters.getParameterValue("CUSTOM_VALUES");
        String text = String.valueOf(values.get(0));
        customValues.addTocHeading(this.level, id, text, customValue);
        return null;
    }
}

