/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.jasper.transformation;

import java.util.Map;
import net.sf.dynamicreports.design.definition.DRIDesignDataset;
import net.sf.dynamicreports.design.definition.DRIDesignReport;
import net.sf.dynamicreports.jasper.base.JasperCustomValues;
import net.sf.dynamicreports.jasper.base.JasperReportDesign;
import net.sf.dynamicreports.jasper.transformation.AbstractExpressionTransform;
import net.sf.dynamicreports.jasper.transformation.BandTransform;
import net.sf.dynamicreports.jasper.transformation.BarcodeTransform;
import net.sf.dynamicreports.jasper.transformation.ChartTransform;
import net.sf.dynamicreports.jasper.transformation.ComponentTransform;
import net.sf.dynamicreports.jasper.transformation.CrosstabTransform;
import net.sf.dynamicreports.jasper.transformation.DatasetTransform;
import net.sf.dynamicreports.jasper.transformation.GroupTransform;
import net.sf.dynamicreports.jasper.transformation.JasperTransformAccessor;
import net.sf.dynamicreports.jasper.transformation.MainDatasetExpressionTransform;
import net.sf.dynamicreports.jasper.transformation.ReportTransform;
import net.sf.dynamicreports.jasper.transformation.StyleTransform;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.design.JasperDesign;

public class JasperTransform
implements JasperTransformAccessor {
    private DRIDesignReport report;
    private JasperReportDesign jasperReportDesign;
    private ReportTransform reportTransform;
    private MainDatasetExpressionTransform mainDatasetExpressionTransform;
    private BandTransform bandTransform;
    private ComponentTransform componentTransform;
    private GroupTransform groupTransform;
    private StyleTransform styleTransform;
    private ChartTransform chartTransform;
    private BarcodeTransform barcodeTransform;
    private CrosstabTransform crosstabTransform;
    private DatasetTransform datasetTransform;
    private AbstractExpressionTransform expressionTransform;

    public JasperTransform(DRIDesignReport report, JasperReportDesign jasperReportDesign) throws DRException {
        this.report = report;
        this.jasperReportDesign = jasperReportDesign;
        this.init();
    }

    private void init() throws DRException {
        this.reportTransform = new ReportTransform(this);
        this.mainDatasetExpressionTransform = new MainDatasetExpressionTransform(this);
        this.groupTransform = new GroupTransform(this);
        this.bandTransform = new BandTransform(this);
        this.componentTransform = new ComponentTransform(this);
        this.styleTransform = new StyleTransform(this);
        this.chartTransform = new ChartTransform(this);
        this.barcodeTransform = new BarcodeTransform(this);
        this.crosstabTransform = new CrosstabTransform(this);
        this.datasetTransform = new DatasetTransform(this);
        this.transformToMainDataset();
    }

    public void transform() {
        this.reportTransform.transform();
        this.datasetTransform.transform();
        this.groupTransform.transform();
        this.mainDatasetExpressionTransform.transform();
        this.reportTransform.transformExpressions();
        this.groupTransform.transformExpressions();
        this.styleTransform.transform();
        this.bandTransform.transform();
        this.reportTransform.addDependencies();
    }

    @Override
    public ReportTransform getReportTransform() {
        return this.reportTransform;
    }

    @Override
    public ChartTransform getChartTransform() {
        return this.chartTransform;
    }

    @Override
    public BarcodeTransform getBarcodeTransform() {
        return this.barcodeTransform;
    }

    @Override
    public CrosstabTransform getCrosstabTransform() {
        return this.crosstabTransform;
    }

    @Override
    public ComponentTransform getComponentTransform() {
        return this.componentTransform;
    }

    @Override
    public void transformToMainDataset() {
        this.transformToDataset(null);
    }

    @Override
    public void transformToDataset(DRIDesignDataset dataset) {
        this.expressionTransform = dataset != null ? this.datasetTransform.getDatasetExpressionTransform(dataset) : this.mainDatasetExpressionTransform;
    }

    @Override
    public AbstractExpressionTransform getExpressionTransform() {
        return this.expressionTransform;
    }

    @Override
    public AbstractExpressionTransform getExpressionTransform(DRIDesignDataset dataset) {
        if (dataset == null) {
            return this.mainDatasetExpressionTransform;
        }
        return this.getDatasetTransform().getDatasetExpressionTransform(dataset);
    }

    @Override
    public GroupTransform getGroupTransform() {
        return this.groupTransform;
    }

    @Override
    public StyleTransform getStyleTransform() {
        return this.styleTransform;
    }

    @Override
    public DatasetTransform getDatasetTransform() {
        return this.datasetTransform;
    }

    @Override
    public DRIDesignReport getReport() {
        return this.report;
    }

    @Override
    public JasperCustomValues getCustomValues() {
        return this.jasperReportDesign.getCustomValues();
    }

    @Override
    public JasperDesign getDesign() {
        return this.jasperReportDesign.getDesign();
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.jasperReportDesign.getParameters();
    }

    @Override
    public Map<String, Object> getParameterValues() {
        return this.report.getParameterValues();
    }

    @Override
    public Integer getStartPageNumber() {
        return this.jasperReportDesign.getStartPageNumber();
    }

    @Override
    public ReportParameters getMasterReportParameters() {
        return this.jasperReportDesign.getMasterReportParameters();
    }
}

