/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder.grid;

import net.sf.dynamicreports.report.base.grid.DRColumnGridList;
import net.sf.dynamicreports.report.base.grid.DRColumnGridListCell;
import net.sf.dynamicreports.report.builder.AbstractBuilder;
import net.sf.dynamicreports.report.builder.grid.ColumnGridComponentBuilder;
import net.sf.dynamicreports.report.builder.grid.HorizontalColumnGridListCellBuilder;
import net.sf.dynamicreports.report.constant.ListType;
import org.apache.commons.lang3.Validate;

public class HorizontalColumnGridListBuilder
extends AbstractBuilder<HorizontalColumnGridListBuilder, DRColumnGridList>
implements ColumnGridComponentBuilder {
    private static final long serialVersionUID = 10000L;
    private DRColumnGridList row;

    protected HorizontalColumnGridListBuilder() {
        super(new DRColumnGridList(ListType.VERTICAL));
        this.init();
    }

    protected void init() {
        this.newRow();
    }

    public HorizontalColumnGridListBuilder add(ColumnGridComponentBuilder ... components) {
        Validate.notNull((Object)components, (String)"components must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])components, (String)"components must not contains null component", (Object[])new Object[0]);
        for (ColumnGridComponentBuilder component : components) {
            this.row.addComponent(component.build());
        }
        return this;
    }

    public HorizontalColumnGridListBuilder add(HorizontalColumnGridListCellBuilder ... cells) {
        Validate.notNull((Object)cells, (String)"cells must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])cells, (String)"cells must not contains null cell", (Object[])new Object[0]);
        for (HorizontalColumnGridListCellBuilder cell : cells) {
            this.row.addCell((DRColumnGridListCell)cell.build());
        }
        return this;
    }

    public HorizontalColumnGridListBuilder newRow() {
        return this.newRow(ListType.HORIZONTAL);
    }

    public HorizontalColumnGridListBuilder newFlowRow() {
        return this.newRow(ListType.HORIZONTAL_FLOW);
    }

    private HorizontalColumnGridListBuilder newRow(ListType listType) {
        this.row = new DRColumnGridList(listType);
        ((DRColumnGridList)this.getObject()).addComponent(this.row);
        return this;
    }

    public HorizontalColumnGridListBuilder setGap(int gap) {
        this.row.setGap(gap);
        return this;
    }

    public HorizontalColumnGridListBuilder setVerticalGap(int gap) {
        ((DRColumnGridList)this.getObject()).setGap(gap);
        return this;
    }

    public DRColumnGridList getColumnGridList() {
        return (DRColumnGridList)this.build();
    }
}

