/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.jhardware.info;

import org.jutils.jhardware.info.HardwareInfo;
import org.jutils.jhardware.info.InfoType;
import org.jutils.jhardware.info.bios.unix.UnixBiosInfo;
import org.jutils.jhardware.info.bios.windows.WindowsBiosInfo;
import org.jutils.jhardware.info.display.unix.UnixDisplayInfo;
import org.jutils.jhardware.info.display.windows.WindowsDisplayInfo;
import org.jutils.jhardware.info.graphicscard.unix.UnixGraphicsCardInfo;
import org.jutils.jhardware.info.graphicscard.windows.WindowsGraphicsCardInfo;
import org.jutils.jhardware.info.memory.unix.UnixMemoryInfo;
import org.jutils.jhardware.info.memory.windows.WindowsMemoryInfo;
import org.jutils.jhardware.info.motherboard.unix.UnixMotherboardInfo;
import org.jutils.jhardware.info.motherboard.windows.WindowsMotherboardInfo;
import org.jutils.jhardware.info.network.unix.UnixNetworkInfo;
import org.jutils.jhardware.info.network.windows.WindowsNetworkInfo;
import org.jutils.jhardware.info.os.unix.UnixOSInfo;
import org.jutils.jhardware.info.os.windows.WindowsOSInfo;
import org.jutils.jhardware.info.processor.unix.UnixProcessorInfo;
import org.jutils.jhardware.info.processor.windows.WindowsProcessorInfo;
import org.jutils.jhardware.util.OSDetector;

public class HardwareFactory {
    private HardwareFactory() {
    }

    public static HardwareInfo get(InfoType type) {
        if (OSDetector.isWindows()) {
            return HardwareFactory.getWindowsInfo(type);
        }
        if (OSDetector.isUnix()) {
            return HardwareFactory.getUnixInfo(type);
        }
        throw new UnsupportedOperationException("Your Operating System is not supported");
    }

    private static HardwareInfo getWindowsInfo(InfoType type) {
        switch (type) {
            case PROCESSOR: {
                return new WindowsProcessorInfo();
            }
            case MEMORY: {
                return new WindowsMemoryInfo();
            }
            case BIOS: {
                return new WindowsBiosInfo();
            }
            case MOTHERBOARD: {
                return new WindowsMotherboardInfo();
            }
            case OS: {
                return new WindowsOSInfo();
            }
            case NETWORK: {
                return new WindowsNetworkInfo();
            }
            case DISPLAY: {
                return new WindowsDisplayInfo();
            }
            case GRAPHICSCARD: {
                return new WindowsGraphicsCardInfo();
            }
        }
        throw new IllegalArgumentException("Type of hardware not supported: " + (Object)((Object)type));
    }

    private static HardwareInfo getUnixInfo(InfoType type) {
        switch (type) {
            case PROCESSOR: {
                return new UnixProcessorInfo();
            }
            case MEMORY: {
                return new UnixMemoryInfo();
            }
            case BIOS: {
                return new UnixBiosInfo();
            }
            case MOTHERBOARD: {
                return new UnixMotherboardInfo();
            }
            case OS: {
                return new UnixOSInfo();
            }
            case NETWORK: {
                return new UnixNetworkInfo();
            }
            case DISPLAY: {
                return new UnixDisplayInfo();
            }
            case GRAPHICSCARD: {
                return new UnixGraphicsCardInfo();
            }
        }
        throw new IllegalArgumentException("Type of hardware not supported: " + (Object)((Object)type));
    }
}

