/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.jhardware.info.graphicscard.windows;

import com.profesorfalken.jsensors.JSensors;
import com.profesorfalken.jsensors.model.components.Gpu;
import com.profesorfalken.jsensors.model.sensors.Fan;
import com.profesorfalken.jsensors.model.sensors.Temperature;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jutils.jhardware.info.graphicscard.AbstractGraphicsCardInfo;
import org.jutils.jhardware.util.DirectXInfoLoader;

public class WindowsGraphicsCardInfo
extends AbstractGraphicsCardInfo {
    @Override
    protected Map<String, String> parseInfo() {
        HashMap<String, String> graphicsCardDataMap = new HashMap<String, String>();
        DirectXInfoLoader directXinfo = DirectXInfoLoader.get;
        List<Map<String, String>> rawDisplayInfoMap = directXinfo.getDisplayInfo();
        List gpus = JSensors.get.components().gpus;
        int numDevice = 0;
        for (Map<String, String> displayInfoMap : rawDisplayInfoMap) {
            graphicsCardDataMap.put("name_" + numDevice, displayInfoMap.get("CardName"));
            graphicsCardDataMap.put("manufacturer_" + numDevice, displayInfoMap.get("Manufacturer"));
            graphicsCardDataMap.put("chip_type_" + numDevice, displayInfoMap.get("ChipType"));
            graphicsCardDataMap.put("dac_type_" + numDevice, displayInfoMap.get("DACType"));
            graphicsCardDataMap.put("device_type_" + numDevice, displayInfoMap.get("DeviceType"));
            if (gpus.size() > numDevice) {
                Gpu gpu = (Gpu)gpus.get(numDevice);
                if (gpu.sensors.temperatures != null && !gpu.sensors.temperatures.isEmpty()) {
                    graphicsCardDataMap.put("temperature_" + numDevice, String.valueOf(((Temperature)gpu.sensors.temperatures.get((int)0)).value.intValue()));
                }
                if (gpu.sensors.fans != null && !gpu.sensors.fans.isEmpty()) {
                    graphicsCardDataMap.put("fan_" + numDevice, String.valueOf(((Fan)gpu.sensors.fans.get((int)0)).value.intValue()));
                }
            }
            ++numDevice;
        }
        graphicsCardDataMap.put("numOfGraphicsCards", String.valueOf(numDevice));
        return graphicsCardDataMap;
    }
}

