/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.jhardware.info.os.unix;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import org.jutils.jhardware.info.os.AbstractOSInfo;
import org.jutils.jhardware.util.HardwareInfoUtils;

public final class UnixOSInfo
extends AbstractOSInfo {
    private static final String OS_RELEASE = "/etc/os-release";
    private static final String LINE_BREAK_REGEX = "\\r?\\n";

    private static String getOSLsbReleaseData() {
        String fullData = "";
        fullData = String.valueOf(fullData) + HardwareInfoUtils.executeCommand("lsb_release", "-a");
        return fullData;
    }

    private static String getOSStartTimeData() {
        String fullData = "";
        fullData = String.valueOf(fullData) + HardwareInfoUtils.executeCommand("last", "-x");
        return fullData;
    }

    private static String getOSReleaseData() {
        Stream<String> streamProcessorInfo = HardwareInfoUtils.readFile(OS_RELEASE);
        StringBuilder buffer = new StringBuilder();
        streamProcessorInfo.forEach(line -> {
            StringBuilder stringBuilder2 = buffer.append((String)line).append("\r\n");
        });
        return buffer.toString();
    }

    @Override
    protected Map<String, String> parseInfo() {
        String[] dataStringLines;
        HashMap<String, String> osDataMap = new HashMap<String, String>();
        String lsbRelease = UnixOSInfo.getOSLsbReleaseData();
        String[] stringArray = dataStringLines = lsbRelease.split(LINE_BREAK_REGEX);
        int n = dataStringLines.length;
        int n2 = 0;
        while (n2 < n) {
            String dataLine = stringArray[n2];
            String[] dataStringInfo = dataLine.split(":");
            osDataMap.put(dataStringInfo[0].trim(), dataStringInfo.length == 2 ? dataStringInfo[1].trim() : "");
            ++n2;
        }
        String osRelease = UnixOSInfo.getOSReleaseData();
        String[] stringArray2 = dataStringLines = osRelease.split(LINE_BREAK_REGEX);
        int n3 = dataStringLines.length;
        n = 0;
        while (n < n3) {
            String dataLine = stringArray2[n];
            String[] dataStringInfo = dataLine.split("=");
            osDataMap.put(HardwareInfoUtils.toCamelCase("OS_" + dataStringInfo[0].trim()), dataStringInfo.length == 2 ? dataStringInfo[1].trim().replaceAll("\"", "") : "");
            ++n;
        }
        String startTimeFullData = UnixOSInfo.getOSStartTimeData();
        String[] stringArray3 = dataStringLines = startTimeFullData.split(LINE_BREAK_REGEX);
        int n4 = dataStringLines.length;
        n3 = 0;
        while (n3 < n4) {
            String dataLine = stringArray3[n3];
            if (dataLine.startsWith("reboot")) {
                osDataMap.put("LastBootTime", UnixOSInfo.normalizeBootUpDate(dataLine.substring(39, 55)));
                break;
            }
            ++n3;
        }
        osDataMap.put("Manufacturer", (String)osDataMap.get("Distributor ID"));
        osDataMap.put("Name", (String)osDataMap.get("Description"));
        osDataMap.put("Version", (String)osDataMap.get("Release"));
        return osDataMap;
    }

    private static String normalizeBootUpDate(String rawBootUpdate) {
        Date returnedDate;
        SimpleDateFormat df = new SimpleDateFormat("EEE MMM dd kk:mm yyyy", Locale.ENGLISH);
        try {
            returnedDate = df.parse(String.valueOf(rawBootUpdate) + " " + Calendar.getInstance().get(1));
        }
        catch (ParseException pe) {
            return rawBootUpdate;
        }
        return returnedDate.toString();
    }
}

