/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.jhardware.info.graphicscard;

import java.util.ArrayList;
import java.util.Map;
import org.jutils.jhardware.info.HardwareInfo;
import org.jutils.jhardware.model.GraphicsCard;
import org.jutils.jhardware.model.GraphicsCardInfo;

public abstract class AbstractGraphicsCardInfo
implements HardwareInfo {
    @Override
    public GraphicsCardInfo getInfo() {
        return this.buildFromDataMap(this.parseInfo());
    }

    protected abstract Map<String, String> parseInfo();

    protected GraphicsCardInfo buildFromDataMap(Map<String, String> dataMap) {
        GraphicsCardInfo info = new GraphicsCardInfo();
        ArrayList<GraphicsCard> graphicsCardList = new ArrayList<GraphicsCard>();
        if (dataMap != null && !dataMap.isEmpty()) {
            int numOfGraphicsCard = Integer.parseInt(dataMap.get("numOfGraphicsCards"));
            int i = 0;
            while (i < numOfGraphicsCard) {
                GraphicsCard graphicsCard = new GraphicsCard();
                graphicsCard.setName(dataMap.get("name_" + i));
                graphicsCard.setManufacturer(dataMap.get("manufacturer_" + i));
                graphicsCard.setChipType(dataMap.get("chip_type_" + i));
                graphicsCard.setDacType(dataMap.get("dac_type_" + i));
                graphicsCard.setDeviceType(dataMap.get("device_type_" + i));
                graphicsCard.setTemperature(dataMap.get("temperature_" + i));
                graphicsCard.setFanSpeed(dataMap.get("fan_speed_" + i));
                graphicsCardList.add(graphicsCard);
                ++i;
            }
        }
        info.setGraphicsCards(graphicsCardList);
        return info;
    }
}

