/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.jhardware.info.os.windows;

import com.profesorfalken.wmi4java.WMI4Java;
import com.profesorfalken.wmi4java.WMIClass;
import java.util.Calendar;
import java.util.Map;
import org.jutils.jhardware.info.os.AbstractOSInfo;

public final class WindowsOSInfo
extends AbstractOSInfo {
    @Override
    protected Map<String, String> parseInfo() {
        Map osDataMap = WMI4Java.get().VBSEngine().getWMIObject(WMIClass.WIN32_OPERATINGSYSTEM);
        osDataMap.put("Version", (String)osDataMap.get("Version"));
        osDataMap.put("LastBootTime", WindowsOSInfo.normalizeBootUpDate((String)osDataMap.get("LastBootUpTime")));
        osDataMap.put("Name", (String)osDataMap.get("Caption"));
        osDataMap.put("Manufacturer", (String)osDataMap.get("Manufacturer"));
        return osDataMap;
    }

    private static String normalizeBootUpDate(String rawBootUpTime) {
        Calendar c = Calendar.getInstance();
        c.set(1, Integer.valueOf(rawBootUpTime.substring(0, 4)));
        c.set(2, Integer.valueOf(rawBootUpTime.substring(4, 6)));
        c.set(5, Integer.valueOf(rawBootUpTime.substring(6, 8)));
        c.set(10, Integer.valueOf(rawBootUpTime.substring(8, 10)));
        c.set(12, Integer.valueOf(rawBootUpTime.substring(10, 12)));
        c.set(13, Integer.valueOf(rawBootUpTime.substring(12, 14)));
        return c.getTime().toString();
    }
}

