/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.design.transformation.chartcustomizer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.sf.dynamicreports.report.constant.OrderType;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DatasetChangeListener;
import org.jfree.data.general.DatasetGroup;

public class SeriesOrderCategoryDataset
implements CategoryDataset,
Serializable {
    private static final long serialVersionUID = 10000L;
    protected List<String> rowKeys;
    protected CategoryDataset dataset;

    public SeriesOrderCategoryDataset(CategoryDataset dataset, Comparator<String> seriesOrderBy, OrderType seriesOrderType) {
        this.dataset = dataset;
        this.rowKeys = new ArrayList<String>();
        for (int i = 0; i < dataset.getRowCount(); ++i) {
            String serieName = (String)((Object)dataset.getRowKey(i));
            this.rowKeys.add(serieName);
        }
        if (seriesOrderBy != null) {
            Collections.sort(this.rowKeys, seriesOrderBy);
        } else {
            Collections.sort(this.rowKeys, new SeriesComparator());
        }
        if (seriesOrderType != null && seriesOrderType.equals((Object)OrderType.DESCENDING)) {
            Collections.reverse(this.rowKeys);
        }
    }

    public Comparable<?> getRowKey(int row) {
        return (Comparable)((Object)this.rowKeys.get(row));
    }

    public int getRowIndex(Comparable key) {
        return this.rowKeys.indexOf(key);
    }

    public List<?> getRowKeys() {
        return this.rowKeys;
    }

    public Comparable<?> getColumnKey(int column) {
        return this.dataset.getColumnKey(column);
    }

    public int getColumnIndex(Comparable key) {
        return this.dataset.getColumnIndex(key);
    }

    public List<?> getColumnKeys() {
        return this.dataset.getColumnKeys();
    }

    public Number getValue(Comparable rowKey, Comparable columnKey) {
        return this.getValue(this.getRowIndex(rowKey), this.getColumnIndex(columnKey));
    }

    public int getRowCount() {
        return this.dataset.getRowCount();
    }

    public int getColumnCount() {
        return this.dataset.getColumnCount();
    }

    public Number getValue(int row, int column) {
        int rowIndex = this.dataset.getRowIndex((Comparable)((Object)this.rowKeys.get(row)));
        return this.dataset.getValue(rowIndex, column);
    }

    public void addChangeListener(DatasetChangeListener listener) {
        this.dataset.addChangeListener(listener);
    }

    public void removeChangeListener(DatasetChangeListener listener) {
        this.dataset.removeChangeListener(listener);
    }

    public DatasetGroup getGroup() {
        return this.dataset.getGroup();
    }

    public void setGroup(DatasetGroup group) {
        this.dataset.setGroup(group);
    }

    private class SeriesComparator
    implements Comparator<String> {
        private SeriesComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            return o1.compareTo(o2);
        }
    }
}

