/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.base;

import net.sf.dynamicreports.report.base.DRMargin;
import net.sf.dynamicreports.report.constant.PageOrientation;
import net.sf.dynamicreports.report.constant.PageType;
import net.sf.dynamicreports.report.definition.DRIPage;
import org.apache.commons.lang3.Validate;

public class DRPage
implements DRIPage {
    private static final long serialVersionUID = 10000L;
    private Integer width;
    private Integer height;
    private PageOrientation orientation;
    private DRMargin margin;
    private Integer columnsPerPage;
    private Integer columnSpace;
    private Boolean ignorePageWidth;

    public void setPageFormat(PageType pageType, PageOrientation orientation) {
        Validate.notNull((Object)((Object)pageType), (String)"pageType must not be null", (Object[])new Object[0]);
        this.setPageFormat(pageType.getWidth(), pageType.getHeight(), orientation);
    }

    public void setPageFormat(Integer width, Integer height, PageOrientation orientation) {
        Validate.isTrue((width >= 0 ? 1 : 0) != 0, (String)"width must be >= 0", (Object[])new Object[0]);
        Validate.isTrue((height >= 0 ? 1 : 0) != 0, (String)"height must be >= 0", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)orientation), (String)"orientation must not be null", (Object[])new Object[0]);
        if (orientation.equals((Object)PageOrientation.PORTRAIT)) {
            this.setWidth(width);
            this.setHeight(height);
        } else {
            this.setWidth(height);
            this.setHeight(width);
        }
        this.setOrientation(orientation);
    }

    @Override
    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        if (width != null) {
            Validate.isTrue((width >= 0 ? 1 : 0) != 0, (String)"width must be >= 0", (Object[])new Object[0]);
        }
        this.width = width;
    }

    @Override
    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        if (height != null) {
            Validate.isTrue((height >= 0 ? 1 : 0) != 0, (String)"height must be >= 0", (Object[])new Object[0]);
        }
        this.height = height;
    }

    @Override
    public PageOrientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(PageOrientation orientation) {
        this.orientation = orientation;
    }

    @Override
    public DRMargin getMargin() {
        return this.margin;
    }

    public void setMargin(DRMargin margin) {
        this.margin = margin;
    }

    @Override
    public Integer getColumnsPerPage() {
        return this.columnsPerPage;
    }

    public void setColumnsPerPage(Integer columnsPerPage) {
        if (columnsPerPage != null) {
            Validate.isTrue((columnsPerPage >= 1 ? 1 : 0) != 0, (String)"columnsPerPage must be >= 1", (Object[])new Object[0]);
        }
        this.columnsPerPage = columnsPerPage;
    }

    @Override
    public Integer getColumnSpace() {
        return this.columnSpace;
    }

    public void setColumnSpace(Integer columnSpace) {
        if (columnSpace != null) {
            Validate.isTrue((columnSpace >= 0 ? 1 : 0) != 0, (String)"columnSpace must be >= 0", (Object[])new Object[0]);
        }
        this.columnSpace = columnSpace;
    }

    @Override
    public Boolean getIgnorePageWidth() {
        return this.ignorePageWidth;
    }

    public void setIgnorePageWidth(Boolean ignorePageWidth) {
        this.ignorePageWidth = ignorePageWidth;
    }
}

