/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder.column;

import net.sf.dynamicreports.report.base.DRGroup;
import net.sf.dynamicreports.report.base.DRVariable;
import net.sf.dynamicreports.report.base.component.DRTextField;
import net.sf.dynamicreports.report.builder.FieldBuilder;
import net.sf.dynamicreports.report.builder.column.ValueColumnBuilder;
import net.sf.dynamicreports.report.builder.datatype.DataTypes;
import net.sf.dynamicreports.report.builder.expression.PercentageExpression;
import net.sf.dynamicreports.report.builder.group.GroupBuilder;
import net.sf.dynamicreports.report.constant.Calculation;
import net.sf.dynamicreports.report.constant.Evaluation;
import net.sf.dynamicreports.report.constant.PercentageTotalType;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.exception.DRReportException;
import org.apache.commons.lang3.Validate;

public class PercentageColumnBuilder
extends ValueColumnBuilder<PercentageColumnBuilder, Double> {
    private static final long serialVersionUID = 10000L;
    private DRIExpression<? extends Number> actualExpression;
    private PercentageTotalType totalType;
    private DRGroup totalGroup;

    protected PercentageColumnBuilder(ValueColumnBuilder<?, ? extends Number> column) {
        Validate.notNull(column, (String)"column must not be null", (Object[])new Object[0]);
        this.actualExpression = (DRIExpression)column.build();
    }

    protected PercentageColumnBuilder(FieldBuilder<? extends Number> field) {
        Validate.notNull(field, (String)"field must not be null", (Object[])new Object[0]);
        this.actualExpression = field.getField();
    }

    public PercentageColumnBuilder setTotalType(PercentageTotalType totalType) {
        this.totalType = totalType;
        return this;
    }

    public PercentageColumnBuilder setTotalGroup(GroupBuilder<?> totalGroup) {
        if (totalGroup != null) {
            this.totalGroup = totalGroup.getGroup();
            this.setTotalType(PercentageTotalType.GROUP);
        } else {
            this.totalGroup = null;
        }
        return this;
    }

    @Override
    protected void configure() {
        DRVariable totalExpression;
        block8: {
            block7: {
                if (((DRTextField)this.getComponent()).getDataType() == null) {
                    ((DRTextField)this.getComponent()).setDataType(DataTypes.percentageType());
                }
                totalExpression = new DRVariable(this.actualExpression, Calculation.SUM);
                if (this.totalType == null) break block7;
                switch (this.totalType) {
                    case REPORT: {
                        totalExpression.setResetType(Evaluation.REPORT);
                        break block8;
                    }
                    case GROUP: {
                        totalExpression.setResetType(Evaluation.GROUP);
                        break block8;
                    }
                    case FIRST_GROUP: {
                        totalExpression.setResetType(Evaluation.FIRST_GROUP);
                        break block8;
                    }
                    case LAST_GROUP: {
                        totalExpression.setResetType(Evaluation.LAST_GROUP);
                        break block8;
                    }
                    default: {
                        throw new DRReportException("Percentage total type " + this.totalType.name() + " not supported.");
                    }
                }
            }
            totalExpression.setResetType(Evaluation.LAST_GROUP);
        }
        totalExpression.setResetGroup(this.totalGroup);
        this.setValueExpression(new PercentageExpression(this.actualExpression, totalExpression));
        super.configure();
    }
}

