/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder.component;

import net.sf.dynamicreports.report.base.component.DRComponent;
import net.sf.dynamicreports.report.base.component.DRXyList;
import net.sf.dynamicreports.report.base.component.DRXyListCell;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.component.DimensionComponentBuilder;
import net.sf.dynamicreports.report.builder.component.XyListCellBuilder;
import org.apache.commons.lang3.Validate;

public class XyListBuilder
extends DimensionComponentBuilder<XyListBuilder, DRXyList> {
    private static final long serialVersionUID = 10000L;

    protected XyListBuilder() {
        super(new DRXyList());
    }

    public XyListBuilder add(Integer x, Integer y, ComponentBuilder<?, ?> component) {
        Validate.notNull((Object)x, (String)"x must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)y, (String)"y must not be null", (Object[])new Object[0]);
        Validate.notNull(component, (String)"component must not be null", (Object[])new Object[0]);
        ((DRXyList)this.getObject()).addComponent(x, y, (DRComponent)component.getComponent());
        return this;
    }

    public XyListBuilder add(Integer x, Integer y, Integer width, Integer height, ComponentBuilder<?, ?> component) {
        Validate.notNull((Object)x, (String)"x must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)y, (String)"y must not be null", (Object[])new Object[0]);
        Validate.notNull(component, (String)"component must not be null", (Object[])new Object[0]);
        if (component instanceof DimensionComponentBuilder) {
            ((DimensionComponentBuilder)component).setWidth(width);
            ((DimensionComponentBuilder)component).setHeight(height);
        }
        ((DRXyList)this.getObject()).addComponent(x, y, (DRComponent)component.getComponent());
        return this;
    }

    public XyListBuilder add(XyListCellBuilder ... cells) {
        Validate.notNull((Object)cells, (String)"cells must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])cells, (String)"cells must not contains null cell", (Object[])new Object[0]);
        for (XyListCellBuilder cell : cells) {
            ((DRXyList)this.getObject()).addCell((DRXyListCell)cell.build());
        }
        return this;
    }

    public DRXyList getXyList() {
        return (DRXyList)this.build();
    }
}

