/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.io.inputstream;

import java.io.IOException;
import java.io.InputStream;

class ZipEntryInputStream
extends InputStream {
    private InputStream inputStream;
    private long numberOfBytesRead = 0L;
    private byte[] singleByteArray = new byte[1];
    private long compressedSize;

    public ZipEntryInputStream(InputStream inputStream, long compressedSize) {
        this.inputStream = inputStream;
        this.compressedSize = compressedSize;
    }

    @Override
    public int read() throws IOException {
        int readLen = this.read(this.singleByteArray);
        if (readLen == -1) {
            return -1;
        }
        return this.singleByteArray[0];
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int readLen;
        if (this.compressedSize != -1L) {
            if (this.numberOfBytesRead >= this.compressedSize) {
                return -1;
            }
            if ((long)len > this.compressedSize - this.numberOfBytesRead) {
                len = (int)(this.compressedSize - this.numberOfBytesRead);
            }
        }
        if ((readLen = this.inputStream.read(b, off, len)) > 0) {
            this.numberOfBytesRead += (long)readLen;
        }
        return readLen;
    }

    public int readHeaders(byte[] b) throws IOException {
        return this.inputStream.read(b);
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    public long getNumberOfBytesRead() {
        return this.numberOfBytesRead;
    }
}

